<?php 
   /**
    *
    * copyright (c) 2013-2021 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    class Banner {
        private $db;
        private $id;
        private $nome;
        private $spazioOccupato;
        private $animazione;
        private $colore;
        private $dataCreazione;
        
        public function __construct($db, $id, $nome="", $spazioOccupato="", $animazione="", $colore="", $dataCreazione="") {
            $this->db = $db;
            $this->id = $id;
            $this->nome = $nome;
            $this->spazioOccupato = $spazioOccupato;
            $this->animazione = $animazione;
            $this->colore = $colore;
            $this->dataCreazione = $dataCreazione;
        }

        function crea() {
            $dataOggi = date("Y-m-d H:s");
            $query    = "INSERT INTO geec_banner VALUES(NULL,'$this->nome','$this->spazioOccupato','$this->animazione','$this->colore','$dataOggi')";
            $this->id = $this->db->eseguiQueryCreazione($query);
            return $this->id;
        }
        
        function modifica() {
            $query    = "UPDATE geec_banner SET nome='$this->nome', spazioOccupato='$this->spazioOccupato', animazione='$this->animazione', colore='$this->colore' WHERE id=$this->id";
            $this->db->eseguiQueryScrittura($query);
        }
        
        function elimina() {
            $this->db->eseguiQueryCancellazione("geec_banner",$this->id);
            
            // elimina le occorrenze in cui la form è presente, l'id di questo componente è 35
            eliminaOccorrenzeComponente($this->db,$this->id,35);
        }
        
        function duplica() {
            $query    = "INSERT INTO geec_banner VALUES(NULL,'Copia di $this->nome')";
            $idNuovaForm = $this->db->eseguiQueryCreazione($query);
            
            $query       = "SELECT * FROM geec_elementiComponente WHERE idForm='$this->id'";
            $risElementi = $this->db->eseguiQueryLettura($query);
            while($elementoDaCopiare = $risElementi->fetch_assoc()) {
                $query = "INSERT INTO `geec_campagneBanner` (`id`, `idForm`, `posizione`, `nome`, `etichetta`, `valore`, `placeholder`, `tipo`, `opzioni`, `obbligatorio`) "
                    . "VALUES (NULL, '$idNuovaForm', '{$elementoDaCopiare["posizione"]}', '{$elementoDaCopiare["nome"]}', '{$elementoDaCopiare["etichetta"]}', '{$elementoDaCopiare["valore"]}', '{$elementoDaCopiare["placeholder"]}', '{$elementoDaCopiare["tipo"]}', '{$elementoDaCopiare["opzioni"]}', '{$elementoDaCopiare["obbligatorio"]}')";
                $this->db->eseguiQueryCreazione($query);
            }
            return $idNuovaForm;
        }
        
        function caricaDatiDalDatabase() {
            $datiBanner   = $this->db->leggiSingolaRiga("geec_banner",$this->id);
            $this->nome = $datiBanner["nome"];
            $this->spazioOccupato  = $datiBanner["spazioOccupato"];
            $this->animazione      = $datiBanner["animazione"];
            $this->colore          = $datiBanner["colore"];
            $this->dataCreazione   = $datiBanner["dataCreazione"];
        }
        
        function creaElemento($nome,$link) {
            $dataOggi = date("Y-m-d H:i");
            $query    = "INSERT INTO `geec_campagneBanner` (`id`, `idBanner`, `attiva`, `nome`, `link`, `immagine`, `immagineMobile`, `spazioOccupato`, `numeroClickOggi`, `numeroClickTotali`, `numeroClickOggiMobile`, `numeroClickTotaliMobile`, `dataCreazione`, `dataUltimoClick`)"
                                                . " VALUES (NULL, '$this->id', 'no', '$nome', '$link', '', '', '', '0', '0', '0', '0', '$dataOggi', '$dataOggi');";
            $idElemento = $this->db->eseguiQueryCreazione($query);
            return $idElemento;
        }
        
        function stampaElementi() {
            
            $query = "SELECT * FROM geec_campagneBanner WHERE idBanner = {$this->id}";
            $risultatoQuery = $this->db->eseguiQueryLettura($query);
            while($campagna = $risultatoQuery->fetch_assoc()) {
                
            ?>
                <div id="elementoComponente<?php echo $campagna["id"] ?>" class="card-body mb-3 py-1 px-2 bg-light border rounded d-sm-flex justify-content-between align-items-center text-center">
                    <div class="d-flex align-items-center">
                        <div class="background-image" style="background: url(../../../<?php echo (($campagna["immagine"]!="") ? $campagna["immagine"] : "immagini/altro/segnaposto.png") ?>)"></div>
                        <div class="mb-1 mb-sm-0 text-muted w-50 text-left w-100">
                            <p class="mb-0"><em><a href="creaElemento.php?id=<?php echo $campagna["id"] ?>"><strong><?php echo $campagna["nome"] ?></strong></a></em></p>
                            <small><em><?php echo $campagna["numeroClickTotali"] ?> click <?php echo(($campagna["numeroClickTotali"]>0) ? "- Ultimo: ".date("d/m/Y H:i",strtotime($campagna["dataUltimoClick"])) : "") ?> </em>  </small>
                        </div>
                    </div>
                    <div class="azioni d-flex align-items-center justify-content-end">
                        <div class="btn-group" role="group" aria-label="Basic example">
                            <button type="button" class="btn btn-light modifica" data-toggle="tooltip" data-placement="bottom" title="" onclick="location.href='creaElemento.php?id=<?php echo $campagna["id"]; ?>';" data-original-title="Configura elemento"><i class="fas fa-cog"></i></button>
                            <button type="button" class="btn btn-light elimina" data-toggle="tooltip" data-placement="bottom" title="" onclick="eliminaElemento(<?php echo $campagna["id"]; ?>,'<?php echo $campagna["nome"]; ?>')" data-original-title="Elimina"><i class="far fa-trash-alt"></i></button>
                        </div>
                    </div>
                </div>
            <?php
            }
        }
        
        function modificaElemento($id,$nome,$link,$attiva) {
            $query = "UPDATE geec_campagneBanner SET nome='$nome', link='$link', attiva='$attiva' WHERE id=$id";
            $this->db->eseguiQueryCreazione($query);
        }
        
        function cambiaImmagineDesktopElemento($idElemento,$percorsoFoto) {
            $query = "UPDATE `geec_campagneBanner` SET  immagine ='$percorsoFoto' WHERE id=$idElemento";
            $this->id = $this->db->eseguiQueryCreazione($query);
        }
                
        function cambiaImmagineMobileElemento($idElemento,$percorsoFoto) {
            $query = "UPDATE `geec_campagneBanner` SET  immagineMobile ='$percorsoFoto' WHERE id=$idElemento";
            $this->id = $this->db->eseguiQueryCreazione($query);
        }
        
        function eliminaElemento($idElemento) {
            $this->db->eseguiQueryCancellazione("geec_campagneBanner",$idElemento);
        }
        
        // getter & setter
        public function getDb() {
            return $this->db;
        }

        public function getId() {
            return $this->id;
        }

        public function getNome() {
            return $this->nome;
        }

        public function getSpazioOccupato() {
            return $this->spazioOccupato;
        }

        public function getAnimazione() {
            return $this->animazione;
        }

        public function getColore() {
            return $this->colore;
        }

        public function getDataCreazione() {
            return $this->dataCreazione;
        }

        public function setDb($db) {
            $this->db = $db;
        }

        public function setId($id) {
            $this->id = $id;
        }

        public function setNome($nome) {
            $this->nome = $nome;
        }

        public function setSpazioOccupato($spazioOccupato) {
            $this->spazioOccupato = $spazioOccupato;
        }

        public function setAnimazione($animazione) {
            $this->animazione = $animazione;
        }

        public function setColore($colore) {
            $this->colore = $colore;
        }

        public function setDataCreazione($dataCreazione) {
            $this->dataCreazione = $dataCreazione;
        }

    }